#version 330
#extension GL_EXT_gpu_shader4 : enable
// Love is WarMod01.fsh  by   belfry
 
//https://www.shadertoy.com/view/wsSXWR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 noise(vec2 p) {
    return fract(1234.1234 * sin(1234.1234 * (fract(1234.1234 * p) + p.yx)));
}

float heart(vec2 p, float s) {
    p /= s;
    vec2 q = p;
    q.x *= 0.5 + .5 * q.y;
    q.y -= abs(p.x) * .63;
    return (length(q) - .7) * s;
}

vec3 hearts(vec2 polar, float time, float fft) {
    float l = clamp(polar.y, 0., 1.);
    float tiling = 1./3.14159 * 14.;
    polar.y -= time;
    vec2 polarID = (floor(polar * tiling));
    
    polar.x = polar.x + polarID.y * .03;
    polar.x = mod(polar.x + 3.14159 * 2., 3.14159 * 2.);
    polarID = floor(polar * tiling);
    
    polar = fract(polar * tiling);
    
    polar = polar * 2. - 1.;
    vec2 n = noise(polarID + .1) * .75 + .25;
    vec2 n2 = 2. * noise(polarID) - 1.;
    vec2 offset = (1. - n.y) * n2;
    float heartDist = heart(polar + offset, n.y * .6);
    float a = smoothstep(.0, .25, n.x*n.x);
    float heartGlow = smoothstep(0., -.05, heartDist) * .5 * a + smoothstep(0.3, -.4, heartDist) * .75;
    vec3 heartCol = vec3(smoothstep(0., -.05, heartDist), 0., 0.) * a + heartGlow * vec3(.9, .5, .7);
    vec3 bgCol = vec3(0.15 + l / 2., .0, 0.);
    return bgCol * (.5 + fft) + heartCol * step(0.45, noise(polarID + .4).x);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (2. * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
    vec2 polar = vec2(atan(uv.y, uv.x), log(length(uv)));
    //float x = mod(polar.x + iTime * .3, 3.14159 * 2.) - 3.14159;
    //float m = smoothstep(0.01, 0., abs(x) - .2);
    float speed = .666;
    float fft = texelFetch(iChannel0, ivec2(1., 0.), 0).x;
    vec3 h = max(max(hearts(polar, iTime * speed, fft), 
                     hearts(polar, iTime * speed * 1.2 + 12., fft)), 
                 hearts(polar, iTime * speed * .8 + 23., fft));
    //uv = 2. * gl_FragCoord.xy / iResolution.xy - 1.;
    //gl_FragColor = vec4(mix(vec3(1. - length(uv) * .075), h, m), 1.);
    gl_FragColor = vec4(h, 1.);
}